package gov.va.vinci.dart.biz;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

@Entity
@Table(name="requestlocationdocument", schema="hib") 
public class RequestLocationDocument {

	private static Log log = LogFactory.getLog(RequestLocationDocument.class);
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	private int id;
	
	@Column(name="requestid")
	private int requestId;
	
	@Column(name="locationid")
	private int locationId;
	
	@Column(name="documentid")
	private int documentId;
	 
	@Column(name="active", columnDefinition = "BIT", length = 1)
	private boolean active;
	
	RequestLocationDocument() {}
	
	public static RequestLocationDocument create(Request request, Location location, Document document) throws ValidationException {
		ValidationHelper.required("Request", request);
		ValidationHelper.required("Location", location);
		ValidationHelper.required("Document", document);
	
		RequestLocationDocument result = new RequestLocationDocument();
		result.requestId = request.getId();
		result.locationId = location.getId();
		result.documentId = document.getId();
		result.active = true;

		DartObjectFactory.getInstance().getRequestLocationDocumentDAO().save(result);
		return result;
	}

	
	public static List<RequestLocationDocument> listByRequestId(final int requestId) {
		return DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestId(requestId);
	}
	
	public static List<RequestLocationDocument> listByRequestAndLocationId(final int requestId, final int locationId) {
		return DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listByRequestAndLocationId(requestId, locationId);
	}

	public static List<RequestLocationDocument> listActiveDocsByRequestAndLocationId(final int requestId, final int locationId) {
		return DartObjectFactory.getInstance().getRequestLocationDocumentDAO().listActiveDocsByRequestAndLocationId(requestId, locationId);
	}
	
	
	public void delete() {
		log.debug("Deleting request location document");
		DartObjectFactory.getInstance().getRequestLocationDocumentDAO().delete(this);
	}
	
	public int getId() {
		return id;
	}
	
	// TESTING ONLY
	public void setId(int id) {
		this.id = id;
	}
	
	public int getRequestId() {
		return requestId;
	}
	
	public int getLocationId() {
		return locationId;
	}
	
	public int getDocumentId() {
		return documentId;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
}
